const sequelize = require("../db");

const formatDate = (date) => {
    const year = date.getFullYear();
    const month = String(date.getMonth() + 1).padStart(2, '0');
    const day = String(date.getDate()).padStart(2, '0');
    const hours = String(date.getHours()).padStart(2, '0');
    const minutes = String(date.getMinutes()).padStart(2, '0');
    const seconds = String(date.getSeconds()).padStart(2, '0');
    return `${year}-${month}-${day} ${hours}:${minutes}:${seconds}`;
};

//get category ID
const GetCategoryID = async (req, res) => {
    try {
        const [results, metadata] = await sequelize.query('SELECT * FROM Category');
        res.json(results);
    } catch (error) {
        return res.status(500).json({ err: error.message })
    }
}

//create category
const CreateCategory = async (req, res) => {
    try {
        const formattedDate = formatDate(new Date());
        const [results, metadata] = await sequelize.query(`
            INSERT INTO Category(CategoryName,IsActive,CreatedDate)
            VALUES(:categoryName, :isActive, :createDate)
            `, {
            replacements: {
                categoryName: req.body.categoryName,
                isActive: req.body.isActive,
                createDate: formattedDate
            }
        });
        res.json(results);
    } catch (error) {
        return res.status(500).json({ error: 'An error occurred' });
    }
}

//get all category details
const GetAllcategoryDetails = async (req, res) => {
    try {
        const [results, metadata] = await sequelize.query("SELECT CategoryID, CategoryName, IsActive FROM Category where categoryname != 'Favourite'order by CategoryName");
        res.json(results);
    } catch (error) {
        return res.status(500).json({ err: error.message })
    }
}

const GetAllcategoryDetailsforBilling = async (req, res) => {
    try {
        const [results, metadata] = await sequelize.query("SELECT CategoryID, CategoryName, IsActive FROM Category WHERE IsActive = 1 ORDER BY CASE WHEN CategoryName = 'favourite' THEN 0 ELSE 1 END, CategoryName");
        res.json(results);
    } catch (error) {
        return res.status(500).json({ err: error.message })
    }
}

// get category details by category id
const GetCategoryDetailsByID = async (req, res) => {
    try {
        const updateID = req.params.updateID;
        const [results, metadata] = await sequelize.query(`
            SELECT CategoryID , CategoryName, IsActive FROM Category WHERE CategoryID = ${updateID}
            `);
        res.json(results);
    } catch (error) {
        res.status(500).send("Server Error");
    }
}

//update selected category detail
const UpdateCategoryDetail = async (req, res) => {
    try {
        const formattedDate = formatDate(new Date());
        const [results, metadata] = await sequelize.query(`
            UPDATE Category
            SET CategoryName = :categoryName,
                IsActive = :isActive,
                ModifiedDate = :modifiedDate
            WHERE CategoryID = :categoryID
        `, {
            replacements: {
                categoryName: req.body.categoryName,
                isActive: req.body.isActive,
                modifiedDate: formattedDate,
                categoryID: req.body.categoryID
            }
        });
        res.json(results);
    } catch (error) {
        return res.status(500).json({ error: 'An error occurred' });
    }
}

//get all category details
const GetAllActiveCategory = async (req, res) => {
    try {
        const [results, metadata] = await sequelize.query('SELECT CategoryID, CategoryName FROM Category WHERE IsActive = 1');
        res.json(results);
    } catch (error) {
        return res.status(500).json({ error: 'An error occurred' });
    }
}


module.exports = {
    GetCategoryID,
    CreateCategory,
    GetAllcategoryDetails,
    GetCategoryDetailsByID,
    UpdateCategoryDetail,
    GetAllActiveCategory,
    GetAllcategoryDetailsforBilling
}