const { json } = require("sequelize");
const sequelize = require("../db");

const formatDate = (date) => {
    const year = date.getFullYear();
    const month = String(date.getMonth() + 1).padStart(2, '0');
    const day = String(date.getDate()).padStart(2, '0');
    const hours = String(date.getHours()).padStart(2, '0');
    const minutes = String(date.getMinutes()).padStart(2, '0');
    const seconds = String(date.getSeconds()).padStart(2, '0');
    return `${year}-${month}-${day} ${hours}:${minutes}:${seconds}`;
};

// Create GRN
const CreateGrn = async (req, res) => {
    //console.log(req.body)
    try {
        const [results, metadata] = await sequelize.query(`
            INSERT INTO grn (
                itemId,
                itemName,
                supplierName,
                qty,
                totalAmount,
                paidAmount,
                grndate 
            ) VALUES (
                :itemId,
                :itemName,
                :supplierName,
                :qty,
                :totalAmount,
                :paidAmount,
                :grndate  
            )
        `, {
            replacements: {
                itemId: req.body.itemId,
                itemName: req.body.itemName,
                supplierName: req.body.supplierName,
                qty: parseInt(req.body.qty),
                totalAmount: parseFloat(req.body.totalAmount),
                paidAmount: parseFloat(req.body.paidAmount),
                grndate: req.body.grndate  
            }
        });
        res.json(results);
    } catch (error) {
        return res.status(400).json({ error: error.message });
    }
};

// Get all GRNs
const GetAllGrns = async (req, res) => {
    try {
        const [results, metadata] = await sequelize.query(`
            SELECT grnKey, itemId, itemName, supplierId, supplierName, itemCategoryId, itemTypeId, qty, totalAmount, paidAmount, creation_date FROM grn
        `);
        res.json(results);
    } catch (error) {
        return res.status(400).json({ error: error.message });
    }
};

// Get GRN by ID
const getgrnbyid = async (req, res) => {
    try {
        const [results, metadata] = await sequelize.query(`
            SELECT grnKey, itemId, itemName, supplierId, supplierName, itemCategoryId, itemTypeId, qty, totalAmount, paidAmount, creation_date FROM grn
            WHERE grnKey = :grnKey
        `,{
            replacements : {
                grnKey : req.body.grnKey
            }
        });
        res.json(results);
    } catch (error) {
        return res.status(400).json({ error: error.message });
    }
};

// Update GRN
const UpdateGrn = async (req, res) => {
    try {
        const grnKey = req.body.grnKey; 
        const [results, metadata] = await sequelize.query(`
            UPDATE grn SET
                itemName = :itemName,
                supplierName = :supplierName,
                qty = :qty,
                totalAmount = :totalAmount,
                paidAmount = :paidAmount
            WHERE grnKey = :grnKey
        `, {
            replacements: {
                grnKey: grnKey,
                itemName: req.body.itemName,
                supplierName: req.body.supplierName,
                qty: parseInt(req.body.qty),
                totalAmount: parseFloat(req.body.totalAmount),
                paidAmount: parseFloat(req.body.paidAmount)
            }
        });
        res.json(results);
    } catch (error) {
        return res.status(400).json({ error: error.message });
    }
};

// Delete GRN
const DeleteGrn = async (req, res) => {
    try {
        const { grnKey } = req.body; 

        // Step 1: Retrieve the GRN record
        const [grnResults] = await sequelize.query(
            `SELECT itemName, qty FROM grn WHERE grnKey = :grnKey`,
            { replacements: { grnKey } }
        );

        if (grnResults.length === 0) {
            return res.status(404).json({ message: "GRN not found." });
        }

        const { itemName, qty } = grnResults[0];

        // Step 2: Delete the GRN record
        await sequelize.query(
            `DELETE FROM grn WHERE grnKey = :grnKey`,
            { replacements: { grnKey } }
        );

        // Step 3: Update the Shop1_Stock
        await sequelize.query(
            `UPDATE Shop1_Stock
             SET stock = stock - :qty
             WHERE itemName = :itemName`,
            { replacements: { qty, itemName } }
        );

        res.json({ message: "GRN deleted and stock updated successfully." });
    } catch (error) {
        res.status(400).json({ error: error.message });
    }
};

module.exports = {
    DeleteGrn,
    UpdateGrn,
    GetAllGrns,
    CreateGrn,
    getgrnbyid
};