const sequelize = require("../db"); // Import sequelize instance

// LoginController function
const LoginController = async (req, res) => {
  const { username, password } = req.body;

  if (!username || !password) {
    return res.status(400).json({ error: "Username and password are required" });
  }

  try {
    // Find the user by username in the 'users' table
    const [user] = await sequelize.query(`
      SELECT * FROM users WHERE username = :username
    `, {
      replacements: { username },
      type: sequelize.QueryTypes.SELECT,
    });

    console.log("User found:", user);

    if (!user) {
      return res.status(401).json({ error: "Invalid username or password" });
    }

    // Compare the provided password with the stored password directly
    if (user.password !== password) {
        console.log("Password mismatch for user:", username);
      return res.status(401).json({ error: "Invalid username or password" });
    }

    // If login is successful, you can generate a session, token, or return user details
    return res.status(200).json({
      message: "Login successful",
      userId: user.id, // Return user ID or any other relevant data
    });

  } catch (error) {
    console.error("Error during login:", error);
    return res.status(500).json({ error: error.message });
  }
};

module.exports = {
  LoginController,
};
