const sequelize = require("../db");
const path = require('path');
const fs = require('fs');

const CreatePet = async (req, res) => {

    //console.log(req);

    try {
        const [results, metadata] = await sequelize.query(`
            INSERT INTO AnimalTypes (AnimalType) 
            VALUES ('${req.body.newPetType}')
        `);
        res.json(results);
    } catch (error) {
        return res.status(500).json({ error: 'An error occurred' });
    }
}

const GetAllPetType = async (req, res) => {
    try {
        const [results, metadata] = await sequelize.query('SELECT * FROM AnimalTypes');
        res.json(results);
    } catch (error) {
        return res.status(500).json({ err: error.message })
    }
}

const GetHistoryByID = async (req, res) => {
    try {
        const updatePetID = req.params.updateID;
        //console.log(updatePetID);

        const [results, metadata] = await sequelize.query(`
            SELECT *
            FROM PetHistory
            WHERE PetID = ${updatePetID}
            ORDER BY Date DESC
            `);
        res.json(results);
    } catch (error) {
        res.status(500).send("Server Error");
    }
}

const AddPet = async (req, res) => {
    const {
        PetTypeDB,
        OwnerName,
        OwnerPhone,
        PetName,
        Breed,
        DOB,
        Age,
        Gender,
        Allergies,
        Description,
        shop, // Include shop field
    } = req.body;



    try {
        // Insert the pet data without petCode
        const [results] = await sequelize.query(
            `INSERT INTO AnimalData 
            (AnimalName, AnimalType, OwnerName, OwnerPhone, Breed, DOB, Age, Gender, Allergies, Description, shop) 
            VALUES 
            (:PetName, :PetTypeDB, :OwnerName, :OwnerPhone, :Breed, :DOB, :Age, :Gender, :Allergies, :Description, :shop)`,
            {
                replacements: {
                    PetName,
                    PetTypeDB,
                    OwnerName,
                    OwnerPhone,
                    Breed,
                    DOB,
                    Age,
                    Gender,
                    Allergies,
                    Description,
                    shop,
                },
            }
        );

        // Get the inserted AnimalID
        const [insertIdResult] = await sequelize.query('SELECT LAST_INSERT_ID() as insertedId');
        const insertedId = insertIdResult[0].insertedId;

        // Determine the prefix based on the shop
        let prefix = '';
        if (shop === 'Ratnapura') {
            prefix = 'RTP';
        } else if (shop === 'Kalawana') {
            prefix = 'KLW';
        } else if (shop === 'Pelmadulla') {
            prefix = 'PLM';
        } else {
            prefix = 'UNK';
        }

        const petCode = `${prefix}${insertedId}`;

        // Update the petCode in the database
        await sequelize.query(
            `UPDATE AnimalData SET petCode = :petCode WHERE AnimalID = :insertedId`,
            {
                replacements: {
                    petCode,
                    insertedId,
                },
            }
        );

        res.status(201).json({ message: 'Pet added successfully', userId: insertedId, petCode });
    } catch (error) {
        console.error('Error inserting pet data:', error);
        res.status(500).json({ error: 'An error occurred' });
    }
};




const GetAllPets = async (req, res) => {
    try {
        const [results, metadata] = await sequelize.query('SELECT * FROM AnimalData order by AnimalName');
        res.json(results);
    } catch (error) {
        res.status(500).json({ error: 'An error occurred' });
    }
}


const AddPetHistory = async (req, res) => {
    try {
        const petID = req.body.updateID;
        const DoctorID = req.body.DoctorID;
        const Description = req.body.Description;

        const [petResult] = await sequelize.query(
            'SELECT petCode FROM AnimalData WHERE AnimalID = :petID',
            {
                replacements: { petID },
                type: sequelize.QueryTypes.SELECT,
            }
        );

        if (!petResult || !petResult.petCode) {
            return res.status(404).json({ error: 'Pet not found' });
        }

        const petCode = petResult.petCode;

        const date = new Date().toISOString().split('T')[0].replace(/-/g, '');

        let filePath = null;

        if (req.files && req.files.file) {
            const uploadedFile = req.files.file;

            const extension = path.extname(uploadedFile.name);

            const filename = `${petCode}${date}${extension}`;

            const dirPath = path.join(__dirname, '..', 'Assets', 'pethistory');

            if (!fs.existsSync(dirPath)) {
                fs.mkdirSync(dirPath, { recursive: true });
            }

            const fullPath = path.join(dirPath, filename);

            await uploadedFile.mv(fullPath);

            filePath = path.join('Assets', 'pethistory', filename);
        }

        await sequelize.query(
            `
        INSERT INTO PetHistory (PetID, Doctor, Description, FilePath) 
        VALUES (:petID, :DoctorID, :Description, :filePath)
      `,
            {
                replacements: {
                    petID,
                    DoctorID,
                    Description,
                    filePath,
                },
            }
        );

        res.json({ message: 'History added successfully' });
    } catch (error) {
        console.error('Error inserting history data:', error);
        return res.status(500).json({ error: 'An error occurred' });
    }
};

const GetUpdateDetailsByID = async (req, res) => {
    const updateID = req.params.petUpdateID;
    try {
        const [results, metadata] = await sequelize.query(`
            SELECT *
            FROM AnimalData 
            WHERE AnimalID = ${updateID}
            `);
        res.json(results);
    } catch (Error) {
        res.status(500).send("Server Error")
    }
}

// Update pet details
const UpdatePetDetails = async (req, res) => {
    console.log("req:> ", req.body)
    try {
        const [results, metadata] = await sequelize.query(`
            UPDATE AnimalData
            SET OwnerName = :OwnerName,
                OwnerPhone = :OwnerPhone,
                AnimalName = :PetName,
                Breed = :Breed,
                DOB = :DOB,
                Age = :Age,
                Gender = :Gender,
                Allergies = :Allergies,
                Description = :Description
            WHERE AnimalID = :petUpdateID
            `, {
            replacements: {
                OwnerName: req.body.OwnerName,
                OwnerPhone: req.body.OwnerPhone,
                PetName: req.body.PetName,
                Breed: req.body.Breed,
                DOB: req.body.DOB,
                Age: req.body.Age,
                Gender: req.body.Gender,
                Allergies: req.body.Allergies,
                Description: req.body.Description,
                petUpdateID: req.body.petUpdateID
            }
        })
        res.json(results);
    } catch (error) {
        return res.status(400).json({ error: error.message })
    }
}



module.exports = {
    CreatePet,
    GetAllPets,
    AddPet,
    GetAllPetType,
    GetHistoryByID,
    AddPetHistory,
    GetUpdateDetailsByID,
    UpdatePetDetails
}