const sequelize = require("../db");
const path = require('path');



const getDailySales = async (req, res) => {
    try {
        const [results, metadata] = await sequelize.query(`
          SELECT 
            DATE(creation_date) AS inv_date,
            username,
            SUM(CASE WHEN paymentmethod = 'card' THEN net_total ELSE 0 END) AS card_total,
            SUM(CASE WHEN paymentmethod = 'cash' THEN net_total ELSE 0 END) AS cash_total,
            SUM(net_total) AS total
        FROM Shop1_Invoice_Header 
        GROUP BY DATE(creation_date), username
        ORDER BY DATE(creation_date) DESC;
        `);
        res.json(results);
    } catch (error) {
        return res.status(500).json({ error: 'An error occurred' });
    }
}
const getMyDailySales = async (req, res) => {

    const me = req.body.username;
    try {
        const [results, metadata] = await sequelize.query(`
          SELECT 
            DATE(creation_date) AS inv_date,
            username,
            SUM(CASE WHEN paymentmethod = 'card' THEN net_total ELSE 0 END) AS card_total,
            SUM(CASE WHEN paymentmethod = 'cash' THEN net_total ELSE 0 END) AS cash_total,
            SUM(net_total) AS all_total
        FROM Shop1_Invoice_Header
        WHERE username = '${me}'
        GROUP BY DATE(creation_date), username
        ORDER BY DATE(creation_date) DESC;
        `);
        res.json(results);
    } catch (error) {
        return res.status(500).json({ error: 'An error occurred' });
    }
}


const getMyDailySalesforPeriod = async (req, res) => {

    const from = req.body.from_Date;
    const to = req.body.to_Date;
    const me = req.body.username;
    try {
        const [results, metadata] = await sequelize.query(`
          SELECT 
            DATE(creation_date) AS inv_date,
            username,
            SUM(CASE WHEN paymentmethod = 'card' THEN net_total ELSE 0 END) AS card_total,
            SUM(CASE WHEN paymentmethod = 'cash' THEN net_total ELSE 0 END) AS cash_total,
            SUM(net_total) AS all_total
        FROM Shop1_Invoice_Header
        WHERE username = '${me}' and 
        DATE(creation_date) BETWEEN '${from}' AND '${to}'
        GROUP BY DATE(creation_date), username
        ORDER BY DATE(creation_date) DESC;
        `);
        res.json(results);
    } catch (error) {
        return res.status(500).json({ error: 'An error occurred' });
    }
}

const getTodaySales = async (req, res) => {
    try {
        const [results, metadata] = await sequelize.query(`
          SELECT DATE(creation_date) as inv_date, SUM(net_total) as Total
            FROM Shop1_Invoice_Header 
            WHERE DATE(creation_date) = CURDATE()
        `);
        res.json(results);
    } catch (error) {
        return res.status(500).json({ error: 'An error occurred' });
    }
}

const getInventory = async (req, res) => {
    try {
        const [results, metadata] = await sequelize.query(`
          SELECT StockId,ItemId,ItemName,StockInDate as 'Last Stock Updated', Stock as 'available Stock'
            FROM Shop1_Stock 
          
        `);
        res.json(results);
    } catch (error) {
        return res.status(500).json({ error: 'An error occurred' });
    }
}

const topSellingProducts = async (req, res) => {
    try {
        const [results, metadata] = await sequelize.query(`
         select item_name,date(creation_date) as inv_date,count(*) as sold
        from Shop1_Invoice_Details
        group by item_name,date(creation_date)
        
          
        `);
        res.json(results);
    } catch (error) {
        return res.status(500).json({ error: 'An error occurred' });
    }
}

const RemainingItemSales = async (req, res) => {
    try {
        const [results, metadata] = await sequelize.query(`
         SELECT g.itemId,g.itemName,sum(g.qty) as TotalQuantity,ss.stock as RemainingQuantity,i.costPrice,i.sellingPrice
        FROM grn as g 
        left join Shop1_Stock ss on g.itemId = ss.itemId 
        left JOIN Item i on g.itemId = i.ItemID
        group by g.itemId,g.itemName
        order by ss.stock desc;
        `);
        res.json(results);
    } catch (error) {
        return res.status(500).json({ error: 'An error occurred' });
    }
}
const InvoiceAnalysis = async (req, res) => {
    try {
        const [results, metadata] = await sequelize.query(`
        SELECT 
            id.inv_no, 
            id.username, 
            id.item_name, 
            id.qty, 
            id.total, 
            SUBSTRING_INDEX(id.creation_date, ' ', 1) AS creation_date,
            ih.gross_total AS bill_gross, 
            ih.discount, 
            ih.net_total,
            ih.paymentmethod
        FROM 
            Shop1_Invoice_Header ih 
        LEFT JOIN 
            Shop1_Invoice_Details id 
            ON ih.inv_no = id.inv_no AND ih.username = id.username
        ORDER BY 
            id.creation_date DESC;
        `);
        res.json(results);
    } catch (error) {
        return res.status(500).json({ error: 'An error occurred' });
    }
}


module.exports = {
    getDailySales,
    getTodaySales,
    getInventory,
    topSellingProducts,
    getMyDailySales,
    getMyDailySalesforPeriod,
    RemainingItemSales,
    InvoiceAnalysis
}