const sequelize = require("../db");


const formatDate = (date) => {
    const year = date.getFullYear();
    const month = String(date.getMonth() + 1).padStart(2, '0');
    const day = String(date.getDate()).padStart(2, '0');
    const hours = String(date.getHours()).padStart(2, '0');
    const minutes = String(date.getMinutes()).padStart(2, '0');
    const seconds = String(date.getSeconds()).padStart(2, '0');
    return `${year}-${month}-${day} ${hours}:${minutes}:${seconds}`;
};


//create supplier
const CreateSupplier = async (req, res) => {
    try {
        const [results, metadata] = await sequelize.query(`
            INSERT INTO Supplier (SupplierName, Address, Email, ContactNo, ProductsSupplied, Remark, IsActive) 
            VALUES (:supplierName, :address, :email, :contactNumber, :productSupplied, :remark, :status)
        `, {
            replacements: {
                supplierName: req.body.supplierName,
                address: req.body.address,
                email: req.body.email,
                contactNumber: req.body.contactNumber,
                productSupplied: req.body.productSupplied,
                remark: req.body.remark,
                status: req.body.status
            }
        });

        res.json(results);
    } catch (error) {
        return res.status(500).json({ error: 'An error occurred' });
    }
}

//get all supplier details
const GetAllSuppluierDetails = async (req, res) => {
    try {
        const [results, metadata] = await sequelize.query('SELECT * FROM Supplier order by SupplierName');
        res.json(results);
    } catch (error) {
        return res.status(500).json({ err: error.message })
    }
}

//get supplier details by id
const GetSupplierDetailsByID = async (req, res) => {
    try {
        const updateSupplierID = req.params.updateID;
        const [results, metadata] = await sequelize.query(`
            SELECT SupplierName, Address, Email, ContactNo, ProductsSupplied,Remark,IsActive 
            FROM Supplier
            WHERE SupplierID = ${updateSupplierID}
            `);
        res.json(results);
    } catch (error) {
        res.status(500).send("Server Error");
    }
}

//update supplier details
const UpdateSupplierDetailsByID = async (req, res) => {
    try {
        const formattedDate = formatDate(new Date());
        const [results, metadata] = await sequelize.query(`
            UPDATE Supplier
            SET SupplierName = :supplierName,
                Address = :address,
                Email = :email,
                ContactNo = :contactNumber,
                ProductsSupplied = :productSupplied,
                Remark = :remark,
                IsActive = :status,
                ModifiedDate = :modifiedDate
            WHERE SupplierID = :updateID
        `, {
            replacements: {
                supplierName: req.body.supplierName,
                address: req.body.address,
                email: req.body.email,
                contactNumber: req.body.contactNumber,
                productSupplied: req.body.productSupplied,
                remark: req.body.remark,
                status: req.body.status,
                modifiedDate: formattedDate,
                updateID: req.body.updateID
            }
        });
        res.json(results);
    } catch (error) {
        return res.status(500).json({ error: 'An error occurred' });
    }
}

//get all active supplier details
const GetAllActiveSupplierDetail = async (req, res) => {
    try {
        const [results, metadata] = await sequelize.query('SELECT SupplierID,SupplierName FROM Supplier WHERE IsActive = 1 order by SupplierName');
        res.json(results);
    } catch (error) {
        return res.status(500).json({ err: error.message })
    }
}

//get all active supplier details for report
const GetAllActiveSupplierDetailForGrid = async (req, res) => {
    try {
        const [results, metadata] = await sequelize.query('SELECT * FROM Supplier WHERE IsActive = 1 order by SupplierName');
        res.json(results);
    } catch (error) {
        return res.status(500).json({ err: error.message })
    }
}


module.exports = {
    CreateSupplier,
    GetAllSuppluierDetails,
    GetSupplierDetailsByID,
    UpdateSupplierDetailsByID,
    GetAllActiveSupplierDetail,
    GetAllActiveSupplierDetailForGrid
}