const sequelize = require("../db");
const jwt = require('jsonwebtoken');
const bycrypt = require('bcryptjs');

const GetAllUser = async (req, res) => {
    try {
        const [results, metadata] = await sequelize.query('SELECT * FROM users');
        res.json(results);
    } catch (error) {
        res.status(500).json({ error: 'An error occurred' });
    }
}


const GetUserByEmail = async (req, res) => {
    //console.log("hi");

    const email = req.params.updateID;
    //console.log(email);

    try {
        const [results, metadata] = await sequelize.query('SELECT * FROM users WHERE email = :email',
            {
                replacements: { email: email }
            }
        );
        res.json(results);
    } catch (error) {
        res.status(500).json({ error: 'An error occurred' });
    }
}
const DeleteUser = async (req, res) => {
    const email = req.params.rowID;
    //console.log(req.body);

    try {
        const [results, metadata] = await sequelize.query('DELETE FROM users WHERE userkey = :email',
            {
                replacements: { email: email }
            }
        );
        res.json(results);
    } catch (error) {
        res.status(500).json({ error: 'An error occurred' });
    }
}

const generateToken = (id) => {
    return jwt.sign(
        { id },
        process.env.JWT_SECRET,
        {
            expiresIn: '30d',
        }
    )
}


const findMe = async (req, res) => {
    const user = req.user;
    //console.log("user from auth from id ", user.Name)
    try {

        const [results, metadata] = await sequelize.query(
            'SELECT Name,role FROM users WHERE Name = :user',
            {
                replacements: { user: user.Name }
            }
        );
        //console.log(results)
        res.status(200).json({ status: 'Success', user: results });
    } catch (e) {
        res.status(400).json({ status: 'error this is from error' });
    }
}


const getUserById = async (userId) => {
    try {
        const [results] = await sequelize.query(
            'SELECT Name, role FROM users WHERE Name = :user',
            {
                replacements: { user: userId }
            }
        );
        //console.log(results)
        return results[0]; // Return the first result or null
    } catch (e) {
        console.error(e);
        throw new Error('Database error');
    }
};



const LoginUser = async (req, res) => {
    const { username, password } = req.body;

    try {
        // Query to fetch the user by username
        const [results] = await sequelize.query(
            'SELECT Name, password, role  FROM users WHERE Name = :username',
            {
                replacements: { username }
            }
        );

        // Check if the user exists
        if (results.length === 0) {
            return res.status(400).json({ error: 'User not found' });
        }

        const user = results[0]; // Get the user data

        // Check if the provided password matches the stored hashed password
        const isPasswordMatch = await bycrypt.compare(password, user.password);

        if (isPasswordMatch) {
            // Generate JWT token
            const token = generateToken(user.Name);

            // Send user data and token back to the frontend
            return res.status(200).json({
                message: 'Login successful',
                token,
                user: {
                    username: user.Name,
                    role: user.role
                }
            });
        } else {
            return res.status(400).json({ error: 'Incorrect username or password' });
        }

    } catch (error) {
        console.error('Login error:', error);
        return res.status(500).json({ error: 'An error occurred during login' });
    }
};


const AddUser = async (req, res) => {
    const { username, email, password, role, branch } = req.body;
    //console.log(username, email, password);
    const salt = await bycrypt.genSalt(10)
    const hashedPass = await bycrypt.hash(password, salt)
    try {
        const [results, metadata] = await sequelize.query(
            'INSERT INTO users (Name , email, password ,role) VALUES (:username, :email, :hashedPass, :role)',
            {
                replacements: { username, email, hashedPass, role }
            }
        );
        res.status(201).json({ message: 'User added successfully', userId: results.insertId });
    } catch (error) {
        //console.log(error);
        res.status(500).json({ error: 'An error occurred' });

    }
}

module.exports = {
    GetAllUser,
    AddUser,
    LoginUser,
    findMe,
    getUserById,
    GetUserByEmail,
    DeleteUser
}
